/**  @file bta_pixel_intrpl.c
*  
*    @brief This file implements the pixel interpolation filter
*  
*    BLT_DISCLAIMER
*  
*    @author Alex Falkensteiner
*  
*    @cond svn
*  
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*  
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_PIXEL_INTRPL_H_INCLUDED
#define BTA_PIXEL_INTRPL_H_INCLUDED


typedef struct BTA_FltPixelIntrplInst  {
    uint32_t **pxIndicesIn;
    uint32_t *pxIndicesOut;
    uint16_t pxCount;
    uint16_t *pxIndicesInLens;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltPixelIntrplInst;


BTA_Status BFLTpixelIntrplInit(BTA_FltPixelIntrplConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTpixelIntrplClose(BTA_FltHandle *handle);
BTA_Status BFLTpixelIntrplApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif
